/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import panther.util.resource.ResourceLog;
import panther.util.resource.ResourcePool;
import panther.util.resource.ResourceReleasedException;
import panther.util.resource.ResourceRevokedException;
import panther.util.resource.ResourceThing;
import panther.util.resource.ResourceTimedOutException;

public class Resource
extends ResourceThing {
    private int usageCount = 0;
    protected ResourcePool pool;
    protected Object rawResourceID;
    protected Object rawResource;
    protected String requester;
    protected String previousRequester;
    protected long assignmentTime;
    protected long lastUseTime;
    protected boolean active = true;
    protected boolean released = false;
    protected boolean timedOut = false;

    public Resource(ResourcePool resourcePool, String string, Object object, Object object2) {
        this.pool = resourcePool;
        this.rawResourceID = object;
        this.rawResource = object2;
        this.requester = string;
        this.assignmentTime = System.currentTimeMillis();
        this.lastUseTime = System.currentTimeMillis();
    }

    public synchronized void copyFrom(Resource resource) {
        this.rawResourceID = resource.rawResourceID;
        this.rawResource = resource.rawResource;
        this.requester = resource.requester;
        this.previousRequester = resource.previousRequester;
        this.assignmentTime = resource.assignmentTime;
        this.lastUseTime = resource.lastUseTime;
        this.usageCount = resource.usageCount;
    }

    public long getAssignmentTime() {
        return this.assignmentTime;
    }

    public long getLastUseTime() {
        return this.lastUseTime;
    }

    public String getPreviousRequester() {
        return this.previousRequester;
    }

    public Object getRawResourceID() {
        return this.rawResourceID;
    }

    public String getRequester() {
        return this.requester;
    }

    public ResourceLog getResourceLog() {
        return this.pool == null ? null : this.pool.getResourceLog();
    }

    public ResourcePool getResourcePool() {
        return this.pool;
    }

    public Resource getTopResource() {
        return this;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean released() {
        return this.released;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public String toString() {
        return this.longString();
    }

    protected synchronized void checkActive() {
        if (!this.isActive()) {
            if (this.timedOut) {
                throw new ResourceTimedOutException("Attempt to access a timed out resource: " + this);
            }
            if (this.released) {
                throw new ResourceReleasedException("Attempt to access a released resource: " + this);
            }
            throw new ResourceRevokedException("Attempt to access a revoked resource: " + this);
        }
    }

    protected Object getRawResource() {
        return this.rawResource;
    }

    protected String getRawResourceName() {
        return "Unknown";
    }

    protected String getTypeName() {
        return "Resource";
    }

    protected String longString() {
        if (this.requester != null) {
            return this.requester + " --> " + this.shortString();
        }
        return "<Prev> " + this.previousRequester + " --> " + this.shortString();
    }

    protected String shortString() {
        return "" + this.rawResourceID;
    }

    synchronized void assign(String string) {
        if (this.requester != null) {
            this.previousRequester = this.requester;
        }
        this.requester = string;
        this.assignmentTime = System.currentTimeMillis();
        this.lastUseTime = System.currentTimeMillis();
        ++this.usageCount;
        this.active = true;
    }

    synchronized void clear() {
        super.clear();
        this.pool = null;
        this.rawResource = null;
    }

    synchronized void destroy() throws Exception {
        this.lastUseTime = System.currentTimeMillis();
        this.active = false;
        this.closeComponents();
    }

    synchronized void recycle() throws Exception {
        this.lastUseTime = System.currentTimeMillis();
        this.active = false;
        this.closeComponents();
    }

    synchronized void refresh() throws Exception {
        this.lastUseTime = System.currentTimeMillis();
    }

    synchronized void release() {
        this.active = false;
        this.released = true;
    }

    synchronized void setRawResource(Object object) {
        this.rawResource = object;
        this.rawResourceID = "Unknown";
    }

    synchronized void timeout() {
        this.active = false;
        this.timedOut = true;
    }

    synchronized void unassign() {
        this.active = false;
        this.previousRequester = this.requester;
        this.requester = null;
    }

    boolean verify() throws Exception {
        this.lastUseTime = System.currentTimeMillis();
        return true;
    }

    public static Resource createEmptyResource(ResourcePool resourcePool) {
        return new Resource(resourcePool, null, null, null);
    }
}

